<?php

/**
* Add to array if value does not exist
*/
function seed_s404p_array_add($arr, $key, $value){
    if (!array_key_exists($key, $arr)) {

        $arr[$key] = $value;
    }
    return $arr;
}

/**
* Page default settings
*/
function seed_s404p_get_page_default_settings(){
    $settings = array();
    // Default Block
    $blocks = array('logo','headline','description','form','search_form','social_profiles','share_buttons','column');
    if(!empty($settings->blocks)){
    foreach($block as $v){
        $settings->blocks = seed_s404p_array_add($v);
    }
    $blocks = $settings->blocks;
    }

    //var_dump($settings);
    //die();

    $fields = array('name');

    $settings = seed_s404p_array_add($settings,'disabled_fields', '');
    $settings = seed_s404p_array_add($settings,'typekit_id', '');
    $settings = seed_s404p_array_add($settings,'publish_method', '');
    $settings = seed_s404p_array_add($settings,'header_scripts', '');
    $settings = seed_s404p_array_add($settings,'footer_scripts', '');
    $settings = seed_s404p_array_add($settings,'conversion_scripts', '');
    $settings = seed_s404p_array_add($settings,'theme_css', '');
    $settings = seed_s404p_array_add($settings,'custom_css', '');
    $settings = seed_s404p_array_add($settings,'footer_affiliate_link', '');
    $settings = seed_s404p_array_add($settings,'credit_type', '');
    $settings = seed_s404p_array_add($settings,'progress_bar_method', '');
    $settings = seed_s404p_array_add($settings,'button_subset', '');
    $settings = seed_s404p_array_add($settings,'show_sharebutton_on', 'thank-you');
    $settings = seed_s404p_array_add($settings,'fields',$fields);
    $settings = seed_s404p_array_add($settings,'blocks',$blocks);
    $settings = seed_s404p_array_add($settings,'logo','');
    $settings = seed_s404p_array_add($settings,'headline','404 Page Not Found');
    $settings = seed_s404p_array_add($settings,'description',"");
    $settings = seed_s404p_array_add($settings,'emaillist','database');
    $settings = seed_s404p_array_add($settings,'privacy_policy_link_text','We promise to never spam you.');
    $settings = seed_s404p_array_add($settings,'thankyou_msg','Thank You!');
    $settings = seed_s404p_array_add($settings,'tweet_text','');
    $settings = seed_s404p_array_add($settings,'facebook_thumbnail','');
    $settings = seed_s404p_array_add($settings,'pinterest_thumbnail','');
    $settings = seed_s404p_array_add($settings,'progress_bar_start_date','');
    $settings = seed_s404p_array_add($settings,'progress_bar_end_date','');
    $settings = seed_s404p_array_add($settings,'progressbar_percentage','0');
    $settings = seed_s404p_array_add($settings,'countdown_date','');
    $settings = seed_s404p_array_add($settings,'countdown_timezone','US/Eastern');
    $settings = seed_s404p_array_add($settings,'countdown_format','dHMS');
    $settings = seed_s404p_array_add($settings,'social_profiles_size','');
    $settings = seed_s404p_array_add($settings,'favicon','');
    $settings = seed_s404p_array_add($settings,'seo_title','');
    $settings = seed_s404p_array_add($settings,'seo_description','');
    $settings = seed_s404p_array_add($settings,'ga_analytics','');
    $settings = seed_s404p_array_add($settings,'footer_credit_text','Go Back Home &#8594;');
    $settings = seed_s404p_array_add($settings,'enable_footercredit','1');
    $settings = seed_s404p_array_add($settings,'footer_credit_type','text');
    $settings = seed_s404p_array_add($settings,'footer_credit_img','');
    $settings = seed_s404p_array_add($settings,'footer_credit_link',home_url());
    $settings = seed_s404p_array_add($settings,'background_color','#ffffff');
    $settings = seed_s404p_array_add($settings,'background_size','cover');
    $settings = seed_s404p_array_add($settings,'background_repeat','no-repeat');
    $settings = seed_s404p_array_add($settings,'background_position','fixed');
    $settings = seed_s404p_array_add($settings,'background_attachment','center top');
    $settings = seed_s404p_array_add($settings,'background_image','');
    $settings = seed_s404p_array_add($settings,'bg_slideshow_slide_speed','3');
    $settings = seed_s404p_array_add($settings,'bg_slideshow_slide_transition','1');
    $settings = seed_s404p_array_add($settings,'bg_video_url','');
    $settings = seed_s404p_array_add($settings,'share_buttons_twitter','');
    $settings = seed_s404p_array_add($settings,'share_buttons_facebook','');
    $settings = seed_s404p_array_add($settings,'share_buttons_facebook_send','');
    $settings = seed_s404p_array_add($settings,'share_buttons_google','');
    $settings = seed_s404p_array_add($settings,'share_buttons_linkedin','');
    $settings = seed_s404p_array_add($settings,'share_buttons_pinit','');
    $settings = seed_s404p_array_add($settings,'share_buttons_tumblr','');
    $settings = seed_s404p_array_add($settings,'show_sharebutton_on_front','');
    $settings = seed_s404p_array_add($settings,'enable_fitvid','1');
    $settings = seed_s404p_array_add($settings,'bg_slideshow','');
    $settings = seed_s404p_array_add($settings,'bg_slideshow_randomize','');
    $settings = seed_s404p_array_add($settings,'bg_video','');
    $settings = seed_s404p_array_add($settings,'bg_video_loop','');
    $settings = seed_s404p_array_add($settings,'container_flat','1');
    $settings = seed_s404p_array_add($settings,'progressbar_effect','');
    $settings = seed_s404p_array_add($settings,'headline_subset','');
    $settings = seed_s404p_array_add($settings,'theme','0');
    $settings = seed_s404p_array_add($settings,'social_profiles_blank','1');
    $settings = seed_s404p_array_add($settings,'headline_font','Open Sans');
    $settings = seed_s404p_array_add($settings,'headline_color','#333333');
    $settings = seed_s404p_array_add($settings,'headline_size','32');
    $settings = seed_s404p_array_add($settings,'headline_weight','400');
    $settings = seed_s404p_array_add($settings,'headline_line_height','1');
    $settings = seed_s404p_array_add($settings,'text_font','Open Sans');
    $settings = seed_s404p_array_add($settings,'text_color','#555555');
    $settings = seed_s404p_array_add($settings,'text_size','16');
    $settings = seed_s404p_array_add($settings,'text_weight','400');
    $settings = seed_s404p_array_add($settings,'text_line_height','1.5');
    $settings = seed_s404p_array_add($settings,'text_subset','');
    $settings = seed_s404p_array_add($settings,'button_font','Open Sans');
    $settings = seed_s404p_array_add($settings,'button_color','#000000');
    $settings = seed_s404p_array_add($settings,'element_border_color','#000000');
    $settings = seed_s404p_array_add($settings,'form_border_color','#000000');
    $settings = seed_s404p_array_add($settings,'form_color','#f5f5f5');
    $settings = seed_s404p_array_add($settings,'button_size','14');
    $settings = seed_s404p_array_add($settings,'button_weight','400');
    $settings = seed_s404p_array_add($settings,'button_line_height','1');
    $settings = seed_s404p_array_add($settings,'container_color','#ffffff');
    $settings = seed_s404p_array_add($settings,'enable_background_overlay','1');
    $settings = seed_s404p_array_add($settings,'background_overlay','rgba(0,0,0,0.5)');
    $settings = seed_s404p_array_add($settings,'container_position','1');
    $settings = seed_s404p_array_add($settings,'container_width','600');
    $settings = seed_s404p_array_add($settings,'form_width','100');
    $settings = seed_s404p_array_add($settings,'container_radius','2');
    $settings = seed_s404p_array_add($settings,'container_effect_animation','');
    $settings = seed_s404p_array_add($settings,'txt_email_field','Email');
    $settings = seed_s404p_array_add($settings,'txt_subscribe_button','Notify Me');
    $settings = seed_s404p_array_add($settings,'txt_search_button','Search');
    $settings = seed_s404p_array_add($settings,'txt_search_placeholder','Search Site');
    $settings = seed_s404p_array_add($settings,'txt_name_field','Name');
    $settings = seed_s404p_array_add($settings,'txt_already_subscribed_msg',"You're already subscribed.");
    $settings = seed_s404p_array_add($settings,'txt_invalid_email_msg','Invalid Email');
    $settings = seed_s404p_array_add($settings,'txt_invalid_name_msg','Invalid Name');
    $settings = seed_s404p_array_add($settings,'txt_stats_referral_url','Your Referral URL is:');
    $settings = seed_s404p_array_add($settings,'txt_stats_referral_clicks','Clicks');
    $settings = seed_s404p_array_add($settings,'txt_stats_referral_stats','Your Referral Stats');
    $settings = seed_s404p_array_add($settings,'txt_stats_referral_subscribers','Conversion');
    $settings = seed_s404p_array_add($settings,'txt_countdown_days','Days');
    $settings = seed_s404p_array_add($settings,'txt_countdown_day','Day');
    $settings = seed_s404p_array_add($settings,'txt_countdown_hours','Hours');
    $settings = seed_s404p_array_add($settings,'txt_countdown_hour','Hour');
    $settings = seed_s404p_array_add($settings,'txt_countdown_minutes','Minutes');
    $settings = seed_s404p_array_add($settings,'txt_countdown_minute','Minute');
    $settings = seed_s404p_array_add($settings,'txt_countdown_seconds','Seconds');
    $settings = seed_s404p_array_add($settings,'txt_countdown_second','Second');
    $settings = seed_s404p_array_add($settings,'google_lang','en');
    return $settings;
}


/**
 * Update cookie length for bypass url
 */
function seed_s404p_change_wp_cookie_logout( $expirein ) {
    global $seed_s404p_bypass_expires;
    if(!empty($seed_s404p_bypass_expires)){
        return $seed_s404p_bypass_expires; // Modify the exire cookie
    }else{
        return $expirein;
    }
}


/**
 * Get roles
 */
function seed_s404p_get_roles() {
    global $wp_roles;
    if ( ! isset( $wp_roles ) )
        $wp_roles = new WP_Roles();
    $roles = $wp_roles->get_names();

    if ( is_multisite() )
        $roles['superadmin'] = __('Super Admin','seedprod');

    return $roles;
}

/**
* Check per
*/
function seed_s404p_cu( $rper = null ) {
    if(!empty($rper)){
        $uper = explode(",", get_option('seed_s404p_per'));
        if(in_array($rper,$uper)){
            return true;
        }else{
            return false;
        }
    }else{
        $a = get_option('seed_s404p_a');
        if($a){
            return true;
        }else{
            return false;
        }
    }
}


/**
 * Get Plugin API value
 */
function seed_s404p_get_plugin_api_value($k = null) {
    return false;
    global $seed_cspv4;
    extract($seed_cspv4);
    if(!empty($plugin_api)){
        $plugin_api = str_replace(array("\n\r","\n"), "&", $plugin_api);
        parse_str($plugin_api, $plugin_api);
        if(array_key_exists($k, $plugin_api)){
            return $plugin_api[$k];
        }else{
            return false;
        }

    }
}

/**
 *  Get IP
 */
function seed_s404p_get_ip(){
    $ip = '';
    if( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) AND strlen($_SERVER['HTTP_X_FORWARDED_FOR'])>6 ){
        $ip = strip_tags($_SERVER['HTTP_X_FORWARDED_FOR']);
    }elseif( !empty($_SERVER['HTTP_CLIENT_IP']) AND strlen($_SERVER['HTTP_CLIENT_IP'])>6 ){
         $ip = strip_tags($_SERVER['HTTP_CLIENT_IP']);
    }elseif(!empty($_SERVER['REMOTE_ADDR']) AND strlen($_SERVER['REMOTE_ADDR'])>6){
         $ip = strip_tags($_SERVER['REMOTE_ADDR']);
    }//endif
    if(!$ip) $ip="127.0.0.1";
    return strip_tags($ip);
}


/**
 *  Get Ref Link
 */
function seed_s404p_ref_link(){
    global $seed_s404p_post_result;
    $ref_link = '';

    if(!empty($seed_s404p_post_result['ref'])){
        $ref_url = $_SERVER["HTTP_REFERER"];
        if(!empty($ref_url)){
            $ref_url_parts = parse_url($ref_url);
            $port = '';
            if(!empty($ref_url_parts['port'])){
                $port = ':'.$ref_url_parts['port'];
            }
            if(!empty($ref_url_parts['port'])){
                if($ref_url_parts['port'] == '80'){
                    $port = '';
                }
            }
            $ref_link = $ref_url_parts['scheme'].'://'.$ref_url_parts['host'].$port.$ref_url_parts['path'];
            $ref_link = $ref_link.'?ref='.$seed_s404p_post_result['ref'];
        }else{

        }
    }else{
        $scheme = 'http';
        if($_SERVER["SERVER_PORT"] == '443'){
            $scheme = 'https';
        }
        $ref_link = $scheme.'://'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
    }
    $ref_link = home_url();
    return $ref_link;
}

/* Import nag */
//add_action( 'admin_menu', 'seed_s404p_import_nag' );

function seed_s404p_import_nag(){
  // cspv4 nag
  if(isset($_GET['action']) && $_GET['action'] == 'seed_s404p_dismiss_v4_nag'){
    update_option('seed_s404p_dismiss_v4_nag',true);
  }
  $v4s = get_option('seed_cspv4');
  $v4_nag = get_option('seed_s404p_dismiss_v4_nag');

  if((isset($_GET['page']) && $_GET['page'] == 'seed_s404p') && !empty($v4s) && empty($v4_nag)){
    add_settings_error(
        null,
        'seed_s404p_import_v4',
        'We have detected settings from Version 4, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_s404p_import&v=cspv4">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_s404p&action=seed_s404p_dismiss_v4_nag">No</a>  ',
        'error'
    );
  }
  // coming-soon nag
  // if(isset($_GET['action']) && $_GET['action'] == 'seed_s404p_dismiss_coming_soon_nag'){
  //   update_option('seed_s404p_dismiss_coming_soon_nag',true);
  // }
  // $coming_soon_s = get_option('seed_csp4_settings_content');
  // $coming_soon_nag = get_option('seed_s404p_dismiss_coming_soon_nag');

  // if((isset($_GET['page']) && $_GET['page'] == 'seed_s404p') && !empty($coming_soon_s) && empty($coming_soon_nag)){

  //   add_settings_error(
  //       null,
  //       'seed_s404p_import_coming_soon',
  //       'We have detected settings from our Free Coming Soon and Maintenance Mode Plugin, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_s404p_import&v=coming-soon">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_s404p&action=seed_s404p_dismiss_coming_soon_nag">No</a>  ',
  //       'error'
  //   );
  // }
}


/* API nag */
add_action( 'admin_menu', 'seed_s404p_api_nag' );

function seed_s404p_api_nag(){
  $api_nag = get_option('seed_s404p_api_nag');
  if((isset($_GET['page']) && $_GET['page'] == 'seed_s404p') && !empty($api_nag)){
    add_settings_error(
        null,
        'seed_s404p_api_nag',
        $api_nag,
        'error'
    );
  }
}

if(seed_s404p_cu('none')){
  add_action( 'admin_menu', 'seed_s404p_l_nag' );
}

function seed_s404p_l_nag(){
  if((isset($_GET['page']) && $_GET['page'] == 'seed_s404p')){
    add_settings_error(
        null,
        'seed_s404p_l_nag',
        '<a href="options-general.php?page=seed_s404p_welcome">Please enter a valid license key.</a>',
        'error'
    );
  }
}


function seed_s404p_extensions() {

	$extensions = array(
		SEED_S404P_PLUGIN_PATH.'extentions/mailchimp/mailchimp.php',
        SEED_S404P_PLUGIN_PATH.'extentions/mailchimp/mailchimp-v3.php',
        SEED_S404P_PLUGIN_PATH.'extentions/convertkit/convertkit.php',
        SEED_S404P_PLUGIN_PATH.'extentions/activecampaign/activecampaign.php',
		SEED_S404P_PLUGIN_PATH.'extentions/database/database.php',
		SEED_S404P_PLUGIN_PATH.'extentions/sendy/sendy.php',
		SEED_S404P_PLUGIN_PATH.'extentions/mailpoet/mailpoet.php',
		SEED_S404P_PLUGIN_PATH.'extentions/madmimi/madmimi.php',
		SEED_S404P_PLUGIN_PATH.'extentions/infusionsoft/infusionsoft.php',
		SEED_S404P_PLUGIN_PATH.'extentions/icontact/icontact.php',
		SEED_S404P_PLUGIN_PATH.'extentions/htmlwebform/htmlwebform.php',
		SEED_S404P_PLUGIN_PATH.'extentions/gravityforms/gravityforms.php',
		SEED_S404P_PLUGIN_PATH.'extentions/followupemails/followupemails.php',
		SEED_S404P_PLUGIN_PATH.'extentions/getresponse/getresponse.php',
		SEED_S404P_PLUGIN_PATH.'extentions/feedburner/feedburner.php',
		SEED_S404P_PLUGIN_PATH.'extentions/constantcontact/constantcontact.php',
		SEED_S404P_PLUGIN_PATH.'extentions/campaignmonitor/campaignmonitor.php',
		SEED_S404P_PLUGIN_PATH.'extentions/aweber/aweber.php',
        SEED_S404P_PLUGIN_PATH.'extentions/drip/drip.php',
        SEED_S404P_PLUGIN_PATH.'extentions/mymail/mymail.php',
        SEED_S404P_PLUGIN_PATH.'extentions/feedblitz/feedblitz.php',
        SEED_S404P_PLUGIN_PATH.'extentions/zapier/zapier.php',
	);

	$active_extensions = apply_filters( 'seed_s404p_active_extensions', $extensions );

	foreach ( $active_extensions as $i ) {
		require_once( $i );
	}

} // END seed_s404p_extensions()

seed_s404p_extensions();


function seed_s404p_select($id,$option_values,$selected = null){
echo "<select id='$id' name='$id' class='form-control input-sm'>";
if(!empty($option_values)){
foreach ( $option_values as $k => $v ) {
	if(is_array($v)){
		echo '<optgroup label="'.ucwords($k).'">';
		foreach ( $v as $k1=>$v1 ) {
			echo '<option value="'.$k1.'"' . selected( $selected , $k1, false ) . ">$v1</option>";
		}
		echo '</optgroup>';
	}else{
			if(!isset($options[ $id ])){
				$options[ $id ] = '';
			}
    		echo "<option value='$k' " . selected( $selected , $k, false ) . ">$v</option>";
	}
}
}
echo "</select> ";
}


