<?php
/**
 * Render Pages
 */


class SEED_CLP{

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;


	function __construct(){
            if(!seed_clp_cu('none')){

                $ts = seed_clp_get_settings();
                if(!empty($ts) && is_array($ts)){
    			 extract($ts);
                }else{
                    return false;
                }


                // Actions & Filters if the landing page is active or being previewed
                if(((!empty($status) && $status === '1') || (isset($_GET['seed_clp_preview'])))){
                    add_action( 'login_enqueue_scripts', array(&$this,'add_scripts') );
                	add_action('login_head', array(&$this,'custom_login_head'),PHP_INT_MAX);
                    add_action('login_head', array(&$this,'custom_login_head2'),PHP_INT_MAX);
                    //add_action('login_footer', array(&$this,'custom_login_footer'));
                    add_action('login_form', array(&$this,'custom_login_form'));
                    add_action('wp_authenticate', array(&$this,'custom_wp_authenticate'));
                    add_filter( 'wp_login_errors', array(&$this,'custom_error_msg'), 10, 2 );
                    remove_filter( 'authenticate', 'wp_authenticate_username_password', 20, 3 );
                    remove_filter( 'authenticate', 'wp_authenticate_email_password', 20, 3 );
                    add_filter( 'authenticate', array(&$this,'wps_authenticate_username_password'), 20, 3 );
                    add_filter( 'authenticate', array(&$this,'wps_authenticate_email_password'), 20, 3 );

                    
                }
            }

        // Deactivate License
        add_action( 'init', array(&$this,'deactivate_license'));
        add_action( 'init', array(&$this,'deactivate_recaptcha'));

        // enable /disable coming soon/maintenanace mode
        add_action( 'init', array(&$this,'clp_api'));
        


    }

    function clp_api(){
        $seed_clp_api_key = '';
        if(defined('SEED_CLP_API_KEY')){
          $seed_clp_api_key = SEED_CSP_API_KEY;
        }
        if(empty($seed_clp_api_key)){
          $seed_clp_api_key = get_option('seed_clp_license_key');
        }
        if(!empty($seed_clp_api_key)){
            if(isset($_REQUEST['seed_clp_token']) && $_REQUEST['seed_clp_token'] == $seed_clp_api_key){
             
                if(isset($_REQUEST['seed_clp_mode'])){
                    $mode = $_REQUEST['seed_clp_mode'];
                    $settings = get_option('seed_clp_settings_content');
                    $settings = maybe_unserialize($settings);

                    if(!empty($settings)){
                        if($mode == 0){
                            $settings['status'] = '0';
                            echo '0';
                            update_option('seed_clp_settings_content',$settings);
                            exit();

                        }elseif($mode == 1){
                            $settings['status'] = '1';
                            echo '1';
                            update_option('seed_clp_settings_content',$settings);
                            exit();

                        }
                    }

                }

            }
        }


    }

/**
 * Remove Wordpress filer and write our own with changed error text.
 */
function wps_authenticate_username_password( $user, $username, $password ) {

    $settings = get_option('seed_clp_customizer_settings');
    $settings = json_decode(json_encode($settings), FALSE);

    if ( $user instanceof WP_User ) {
        return $user;
    }


    if ( empty($username) || empty($password) ) {
        if ( is_wp_error( $user ) )
            return $user;

        $error = new WP_Error();

        if ( empty($username) ){
            if(!empty($settings->error_empty_username)){
              $error->add('empty_username', $settings->error_empty_username);
            }else{
              $error->add('empty_username', __('<strong>ERROR</strong>: The username field is empty.'));  
            }
        }
            

        if ( empty($password) ){
            if(!empty($settings->error_empty_password)){
                $error->add('empty_password', $settings->error_empty_password);
            }else{
                $error->add('empty_password', __('<strong>ERROR</strong>: The password field is empty.'));
            }
        }

        return $error;
    }



    $user = get_user_by('login', $username);

    if ( !$user ) {
        if(!empty($settings->error_invalid_username)){
            return new WP_Error( 'incorrect_username',
                html_entity_decode(str_replace(array('WP_LOSTPASSWORD_URL'),array(wp_lostpassword_url()),$settings->error_invalid_username))
            );
        }else{
            return new WP_Error( 'invalid_username',
                __( '<strong>ERROR</strong>: Invalid username.' ) .
                ' <a href="' . wp_lostpassword_url() . '">' .
                __( 'Lost your password?' ) .
                '</a>'
            );
        }
    }

    $user = apply_filters( 'wp_authenticate_user', $user, $password );
    if ( is_wp_error($user) )
        return $user;

    if ( ! wp_check_password( $password, $user->user_pass, $user->ID ) ) {
        if(!empty($settings->error_invalid_password)){
            return new WP_Error( 'incorrect_password',
                html_entity_decode(str_replace(array('WP_LOSTPASSWORD_URL','USERNAME'),array(wp_lostpassword_url(), $username),$settings->error_invalid_password))
            );
        }else{
            return new WP_Error( 'incorrect_password',
                sprintf(
                    /* translators: %s: user name */
                    __( '<strong>ERROR</strong>: The password you entered for the username %s is incorrect.' ),
                    '<strong>' . $username . '</strong>'
                ) .
                ' <a href="' . wp_lostpassword_url() . '">' .
                __( 'Lost your password?' ) .
                '</a>'
            );
        }
    }

    return $user;
}

function wps_authenticate_email_password( $user, $email, $password ) {

    $settings = get_option('seed_clp_customizer_settings');
    $settings = json_decode(json_encode($settings), FALSE);

    if ( $user instanceof WP_User ) {
        return $user;
    }


    if ( empty($email) || empty($password) ) {
        if ( is_wp_error( $user ) )
            return $user;

        $error = new WP_Error();

        if ( empty($email) ){
            if(!empty($settings->error_empty_username)){
              $error->add('empty_username', $settings->error_empty_username);
            }else{
              $error->add('empty_username', __('<strong>ERROR</strong>: The email field is empty.'));  
            }
        }
            

        if ( empty($password) ){
            if(!empty($settings->error_empty_password)){
                $error->add('empty_password', $settings->error_empty_password);
            }else{
                $error->add('empty_password', __('<strong>ERROR</strong>: The password field is empty.'));
            }
        }

        return $error;
    }

    if ( ! is_email( $email ) ) {
        return $user;
    }

    $user = get_user_by('email', $email);

    if ( !$user ) {
        if(!empty($settings->error_invalid_username)){
            return new WP_Error( 'incorrect_email',
                html_entity_decode(str_replace(array('WP_LOSTPASSWORD_URL'),array(wp_lostpassword_url()),$settings->error_invalid_username))
            );
        }else{
            return new WP_Error( 'invalid_email',
                __( '<strong>ERROR</strong>: Invalid username.' ) .
                ' <a href="' . wp_lostpassword_url() . '">' .
                __( 'Lost your password?' ) .
                '</a>'
            );
        }
    }

    $user = apply_filters( 'wp_authenticate_user', $user, $password );
    if ( is_wp_error($user) )
        return $user;

    if ( ! wp_check_password( $password, $user->user_pass, $user->ID ) ) {
        if(!empty($settings->error_invalid_password)){
            return new WP_Error( 'incorrect_password',
                html_entity_decode(str_replace(array('WP_LOSTPASSWORD_URL','USERNAME'),array(wp_lostpassword_url(), $username),$settings->error_invalid_password))
            );
        }else{
            return new WP_Error( 'incorrect_password',
                sprintf(
                    /* translators: %s: user name */
                    __( '<strong>ERROR</strong>: The password you entered for the email %s is incorrect.' ),
                    '<strong>' . $email . '</strong>'
                ) .
                ' <a href="' . wp_lostpassword_url() . '">' .
                __( 'Lost your password?' ) .
                '</a>'
            );
        }
    }

    return $user;
}


    /**
     * Return an instance of this class.
     */
    public static function get_instance() {

        // If the single instance hasn't been set, set it now.
        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     *  Deactivate Recaptcha
     */
    function deactivate_recaptcha(){
        $token = get_option('seed_clp_token');
        if((isset($_REQUEST['seed_clp_token']) && $_REQUEST['seed_clp_token'] == $token) && (isset($_REQUEST['seed_clp_action']) && $_REQUEST['seed_clp_action'] == 'deactivate_recaptcha')) {
            $settings = get_option('seed_clp_customizer_settings');
            unset($settings['enable_recaptcha']);
            //var_dump($settings);
            update_option('seed_clp_customizer_settings',$settings);
            echo 'true';

            exit();
        }
    }



    /**
     *  Deactivate License
     */
    function deactivate_license(){
        $token = get_option('seed_clp_token');
        if((isset($_REQUEST['seed_clp_token']) && $_REQUEST['seed_clp_token'] == $token) && (isset($_REQUEST['seed_clp_action']) && $_REQUEST['seed_clp_action'] == 'deactivate')) {
                    $seed_clp_per = '';
                    if(!empty($_REQUEST['seed_clp_per'])){
                        $seed_clp_per = $_REQUEST['seed_clp_per'];
                    }

                    $seed_clp_api_nag='Site Deactivated';
                    if(!empty($_REQUEST['seed_clp_api_nag'])){
                        $seed_clp_api_nag = $_REQUEST['seed_clp_api_nag'];
                    }

                    update_option('seed_clp_api_nag',$seed_clp_api_nag);
                    update_option('seed_clp_api_message',$seed_clp_api_nag);
                    update_option('seed_clp_a',false);
                    update_option('seed_clp_per',$seed_clp_per);
                    update_option('seed_clp_license_key','');

                    echo 'true';

            exit();
        }
    }

    function custom_error_msg( $errors, $redirect_to ) {
        if ( isset($_GET['seed_clp_recaptcha_error']) && 1 == $_GET['seed_clp_recaptcha_error'] ){
            $errors->add('recaptcha', __('Please verify you are not a Robot'), 'message');
        }

       return $errors;
    }

    function custom_wp_authenticate(){
        // Get Settings
        $settings = get_option('seed_clp_customizer_settings');
        $settings = json_decode(json_encode($settings), FALSE);

        if($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['seed_clp_recaptcha'])){
        if(!empty($settings->enable_recaptcha)){
            if(!empty($settings->recaptcha_site_key)){
                if(!empty($settings->recaptcha_secret_key)){
                    $response = wp_remote_post( 'https://www.google.com/recaptcha/api/siteverify', 
                        array('body' => array( 
                            'secret' =>  $settings->recaptcha_secret_key, 
                            'response' => $_REQUEST['g-recaptcha-response'] 
                            )
                        )
                        );

                    $body = json_decode(wp_remote_retrieve_body($response));

                    if($body->success === false){
                         header('Location: wp-login.php?seed_clp_recaptcha_error=1');
                         exit();
                    }
                }}}
        }
    }

    function custom_login_form(){
        // Get Settings
        $settings = get_option('seed_clp_customizer_settings');
        $settings = json_decode(json_encode($settings), FALSE);
        ?>
        <?php if(!empty($settings->enable_recaptcha)){ ?>
        <?php if(!empty($settings->recaptcha_site_key)){ ?>
        <?php if(!empty($settings->recaptcha_secret_key)){ ?>
        <input type="hidden" name="seed_clp_recaptcha" value="1"></input> 
        <div class="g-recaptcha" data-sitekey="<?php echo $settings->recaptcha_site_key ?>"></div>
        <?php }}} ?>
        <?php

    }

    function add_scripts(){
        wp_enqueue_script('jquery');
    }

    function custom_login_head(){
        // Get Settings
        $settings = get_option('seed_clp_customizer_settings');
        $settings = json_decode(json_encode($settings), FALSE);
        require_once(SEED_CLP_PLUGIN_PATH.'lib/seed_clp_lessc.inc.php');


        ?>
        <?php if(!empty($settings->container_effect_animation)): ?>
        <!-- Animate CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.1/animate.min.css">
        <?php endif; ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.min.css">
        <?php if(!empty($settings->text_font)): ?>
        <?php if(strpos($settings->text_font,",") === false): ?>
        <link class="gf-text" href='https://fonts.googleapis.com/css?family=<?php echo urlencode(str_replace("'","",stripslashes($settings->text_font))); ?>:<?php echo $settings->text_weight; ?>&subset=<?php echo $settings->text_subset; ?>' rel='stylesheet' type='text/css'>
        <?php endif; ?>
        <?php endif; ?>
        <?php if(!empty($settings->enable_recaptcha)){ ?>
        <?php if(!empty($settings->recaptcha_site_key)){ ?>
        <?php if(!empty($settings->recaptcha_secret_key)){ ?>
        <!-- Recaptcha -->
        <script src="https://www.google.com/recaptcha/api.js"></script>
        <?php }}} ?>

       <?php if(!empty($settings->bg_video) && empty($video_id) ): ?>
        <!-- BigVideo -->
        <link rel="stylesheet" href="<?php echo SEED_CLP_PLUGIN_URL ?>inc/css/video-slideshow.css">
        <?php endif; ?>

        <script src="<?php echo SEED_CLP_PLUGIN_URL ?>lib/modernizr-custom.js"></script>
        <style>

        html{
            height:100%;
            <?php if(!empty($settings->background_image)): ?>
                    background: <?php echo $settings->background_color; ?> url(<?php echo $settings->background_image; ?>) <?php echo $settings->background_repeat; ?> <?php echo $settings->background_position; ?> <?php echo $settings->background_attachment; ?>;
                    <?php if(!empty($settings->background_size)): ?>
                        -webkit-background-size: <?php echo $settings->background_size; ?>;
                        -moz-background-size: <?php echo $settings->background_size; ?>;
                        -o-background-size: <?php echo $settings->background_size; ?>;
                        background-size: <?php echo $settings->background_size; ?>;
                    <?php endif; ?>
            <?php else: ?>
                background: <?php echo $settings->background_color; ?>;
            <?php endif; ?>
        }

        body{
            background:transparent;
        }

        body,p, .login form{
             font-family: <?php echo $settings->text_font; ?>;
             font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
             font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
             font-size: <?php echo $settings->text_size; ?>px;
             line-height: <?php echo $settings->text_line_height; ?>em;
        }



        body, p, .login label,.login form,.wp-core-ui .button, .wp-core-ui .button-primary, .wp-core-ui .button-secondary,.login form .forgetmenot label,a{
            font-size: <?php echo $settings->text_size; ?>px;
        }

        .wp-core-ui .button.button-large, .wp-core-ui .button-group.button-large .button{
            height:<?php echo ($settings->text_size*2)+2; ?>px;
        }

        #nav a, #backtoblog a{
         font-size: <?php echo $settings->text_size - 1; ?>px;
        }

        <?php 
        if(!empty($settings->logo)){ 
        $ratio = $settings->logo_width /  $settings->logo_height;
        $targetWidth = $targetHeight = min(320, max($settings->logo_width, $settings->logo_height));
        if ($ratio < 1) {
            $targetWidth = $targetHeight * $ratio;
        } else {
            $targetHeight = $targetWidth / $ratio;
        }
        }
        // var_dump($targetHeight);
        // die();

        if(!empty($settings->logo)){ ?>
        .login h1 a{
            background-image: url(<?php echo $settings->logo; ?>);
            background-size: <?php echo $targetWidth; ?>px <?php echo $targetHeight;; ?>px;
            height: <?php echo $targetHeight; ?>px;
            width: <?php echo $targetWidth; ?>px;

        }
        <?php } ?>

        <?php if(!empty($settings->container_transparent)){ ?>
        .login form{
            background:transparent;
            -webkit-box-shadow: none;
            box-shadow: none;
        }
        <?php }else{ ?>
        .login form{
            background:<?php echo $settings->container_color; ?>;
        }
        <?php } ?>

        .login form{
            border-radius: <?php echo $settings->container_radius; ?>px;
        }

        #clpio-page{
            min-height: 100%;
        }

        .flexbox #clpio-page{
            padding-left:20px;
            padding-right:20px;
        }

        #clpio-login-desc{
            color: #72777c;
            margin-bottom:16px;
            text-align:center;
        }

        #clpio-login-desc-below{
            clear:both;
            color: #72777c;
            padding-top:16px;
            text-align:center
        }

        #clpio-social-profiles{
            clear:both;
            padding-top:16px;
                text-align: center;
        }
        #login form{
            padding-bottom:26px;

        }

        #login{
        width:100%;
        max-width: <?php echo $settings->container_width; ?>px;
        <?php if(!empty($settings->container_effect_animation)){ ?>
        visibility:hidden;
        <?php } ?>
        }

        #clpio-login-desc,#clpio-login-desc-below,.login label{
            color: <?php echo $settings->text_color; ?>;
        }

        #clpio-social-profiles a, #clpio-login-desc a,#clpio-login-desc-below a, #login_error a{
            color: <?php echo $settings->button_color; ?>;
        }

        .login form a{
            text-decoration:none;
        }
        .login form a:hover{
            text-decoration:underline;
        }

        <?php
        if(!empty($settings->button_color)){
        $css = "
        @buttonColor: {$settings->button_color};
        @primaryColor: {$settings->form_color};
        @dark_color1: darken(@primaryColor, 10%);
        @dark_color3: darken(@primaryColor, 20%);
        @light_color3: lighten(@primaryColor, 10%);
        .lightordark (@c) when (lightness(@c) >= 65%) {
            color: black;

        }
        .lightordark (@c) when (lightness(@c) < 65%) {
            color: white;

        }

        .login form .input, .login input[type='text'], .login form input[type='checkbox']{
            background-color: @primaryColor;
            .lightordark (@primaryColor);
        }

        input[type='text']:focus, input[type='password']:focus, input[type='color']:focus, input[type='date']:focus, input[type='datetime']:focus, input[type='datetime-local']:focus, input[type='email']:focus, input[type='month']:focus, input[type='number']:focus, input[type='password']:focus, input[type='search']:focus, input[type='tel']:focus, input[type='text']:focus, input[type='time']:focus, input[type='url']:focus, input[type='week']:focus, input[type='checkbox']:focus, input[type='radio']:focus, select:focus, textarea:focus{
            border-color: @buttonColor;
            -webkit-box-shadow: 0 0 2px @buttonColor;
            box-shadow: 0 0 2px @buttonColor;
        }



        ";
        try {

            $less = new seed_clp_lessc();
            $style = $less->parse($css);
            echo $style;
        } catch (Exception $e) {
            echo $e;
        }
        }
        ?>

        .login .message, .login #login_error{
            border-left: 4px solid <?php echo $settings->button_color; ?>;
            border-radius: <?php echo $settings->error_msg_radius; ?>px;
            color: <?php echo $settings->error_msg_txt_color; ?>;
            background-color: <?php echo $settings->error_msg_bg_color; ?>;
        }

        <?php
        if(!empty($settings->button_color)){
        $css = "
        @primaryColor: {$settings->button_color};
        @dark_color1: darken(@primaryColor, 10%);
        @dark_color3: darken(@primaryColor, 20%);
        @light_color3: lighten(@primaryColor, 10%);

        .lightordark (@c) when (lightness(@c) >= 65%) {
            color: black;
            text-shadow: 0 -1px 0 @light_color3;
        }
        .lightordark (@c) when (lightness(@c) < 65%) {
            color: white;
            text-shadow: 0 -1px 0 @dark_color3;
        }

        .wp-core-ui .button, .wp-core-ui .button-secondary .button-primary{
            background-color: @primaryColor;
            border-color: @dark_color1;
            box-shadow: 0 1px 0  @dark_color3;
            .lightordark (@primaryColor);
        }
        .wp-core-ui .button:hover, .wp-core-ui .button-primary:hover,.wp-core-ui  .button-primary:focus,.wp-core-ui  .button-primary:active {
            background-color: @dark_color1;
            border-color: @dark_color1;
            box-shadow: 0 1px 0  @dark_color3;
            .lightordark (@primaryColor);
        }

        #clpio-social-profiles a:hover, #clpio-login-desc a:hover,#clpio-login-desc-below a:hover, #login_error a:hover{
            color: @dark_color1;
        }




        ";
        try {

            $less = new seed_clp_lessc();
            $style = $less->parse($css);
            echo $style;
        } catch (Exception $e) {
            echo $e;
        }
        }
        ?>

        .login #nav a, .login #backtoblog a, .login #nav a:hover, .login #backtoblog a:hover{
            color: <?php echo $settings->text_link_color; ?>;
        }

        .login #nav a:hover, .login #backtoblog a:hover{
            text-decoration:underline;
        }

        <?php if(!empty($settings->enable_background_overlay) && !empty($settings->background_overlay)): ?>
        #clpio-page{
            background-color: <?php echo $settings->background_overlay; ?>;
        }
        <?php endif; ?>

        <?php 
        if(!empty($settings->button_flat)): ?>
            .wp-core-ui .button, .wp-core-ui .button-secondary .button-primary, .wp-core-ui .button:hover, .wp-core-ui .button-primary:hover,.wp-core-ui  .button-primary:focus,.wp-core-ui  .button-primary:active{
              border:none;
              text-shadow:none;
              box-shadow:none;
            }
        <?php endif; ?>


        <?php 
        if(!empty($settings->hide_logo)): ?>
            #login h1:first-child{
              display:none;
            }
        <?php endif; ?>

        <?php 
        if(!empty($settings->logo_margin_bottom)): ?>
            #login h1:first-child{
              margin-bottom: <?php echo $settings->logo_margin_bottom; ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->form_m_t)): ?>
            #loginform{
                margin-top: <?php echo intval($settings->form_m_t); ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->form_m_l)): ?>
            #loginform{
                margin-left: <?php echo intval($settings->form_m_l); ?>px;
            }
        <?php endif; ?>
                
        <?php if(!empty($settings->form_m_b)): ?>
            #loginform{
                margin-bottom: <?php echo intval($settings->form_m_b); ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->form_m_r)): ?>
            #loginform{
                margin-right: <?php echo intval($settings->form_m_r); ?>px;
            }
        <?php endif; ?>


        <?php if(!empty($settings->form_p_t)): ?>
            #loginform{
                padding-top: <?php echo intval($settings->form_p_t); ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->form_p_l)): ?>
            #loginform{
                padding-left: <?php echo intval($settings->form_p_l); ?>px;
            }
        <?php endif; ?>
                
        <?php if(!empty($settings->form_p_b)): ?>
            #loginform{
                padding-bottom: <?php echo intval($settings->form_p_b); ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->form_p_r)): ?>
            #loginform{
                padding-right: <?php echo intval($settings->form_p_r); ?>px;
            }
        <?php endif; ?>

        <?php if(!empty($settings->hide_remember_me)): ?>
            .forgetmenot{
                display:none;
            }
        <?php endif; ?>

        <?php if(!empty($settings->hide_forgot_password)): ?>
            #nav{
                display:none;
            }
        <?php endif; ?>

        <?php if(!empty($settings->hide_back_link)): ?>
            #backtoblog{
                display:none;
            }
        <?php endif; ?>



        <?php if(!empty($settings->container_position)){ ?>
        .flexbox #clpio-page{
            display:flex;
            flex-direction: column;
        }


        .flexbox #login{
            padding:0;
            margin:20px;
        }

        .flexbox #clpio-page{
            <?php if($settings->container_position == '1'): ?>
                -webkit-align-items: center;
                -webkit-justify-content: center;
                align-items: center;
                justify-content: center;
            <?php endif; ?>
            <?php if($settings->container_position == '2'): ?>
                -webkit-align-items: flex-start;
                -webkit-justify-content: center;
                align-items: flex-start;
                justify-content: center;
            <?php endif; ?>
            <?php if($settings->container_position == '3'): ?>
                -webkit-align-items: flex-end;
                -webkit-justify-content: center;
                align-items: flex-end;
                justify-content: center;
            <?php endif; ?>
            <?php if($settings->container_position == '4'): ?>
                -webkit-align-items: center;
                -webkit-justify-content: flex-start;
                align-items: center;
                justify-content: flex-start;
            <?php endif; ?>
            <?php if($settings->container_position == '5'): ?>
                -webkit-align-items: flex-start;
                -webkit-justify-content: flex-start;
                align-items: flex-start;
                justify-content: flex-start;
            <?php endif; ?>
            <?php if($settings->container_position == '6'): ?>
                -webkit-align-items: flex-end;
                -webkit-justify-content: flex-start;
                align-items: flex-end;
                justify-content: flex-start;
            <?php endif; ?>
            <?php if($settings->container_position == '7'): ?>
                -webkit-align-items: center;
                -webkit-justify-content: flex-end;  
                align-items: center;
                justify-content: flex-end;
            <?php endif; ?>
            <?php if($settings->container_position == '8'): ?>
                -webkit-align-items: flex-start;
                -webkit-justify-content: flex-end;
                align-items: flex-start;
                justify-content: flex-end;
            <?php endif; ?>
            <?php if($settings->container_position == '9'): ?>
                -webkit-align-items: flex-end;
                -webkit-justify-content: flex-end;
                align-items: flex-end;
                justify-content: flex-end;
            <?php endif; ?>
            }
        <?php } ?>

        <?php if(!empty($settings->custom_css)){
            echo $settings->custom_css;
        }
        ?>



        </style>
        <?php 

     
    }


    function custom_login_footer(){
       //var_dump('sfsf');
        // Get Settings
        $settings = get_option('seed_clp_customizer_settings');
        $settings = json_decode(json_encode($settings), FALSE);
    }
   
    function custom_login_head2(){
        $settings = get_option('seed_clp_customizer_settings');
        $settings = json_decode(json_encode($settings), FALSE);

        $social_profiles = '';

        // Get social Profiles
        if(!empty($settings->social_profiles)){
        ob_start();
        foreach($settings->social_profiles as $k => $v){ 

            //check url for custom icon
            $icon_image = '';
            $url_split = explode("|",$v->url);
            $v->url = $url_split[0];
            if(!empty($url_split[1])){
                //check for icon
                if(substr( $url_split[1], 0, 3 ) === "fa-"){
                    $v->icon = $url_split[1];
                }
                //check for custom image
                if(substr( $url_split[1], 0, 4 ) === "http"){
                    $icon_image = $url_split[1];
                }

            }

            
            if (filter_var($v->url, FILTER_VALIDATE_EMAIL)) {
                $v->url = "mailto:".str_replace("mailto:","",$v->url);
            }elseif($v->icon == 'fa-skype'){
            }else{
                
                if (filter_var($v->url, FILTER_VALIDATE_URL) === false) {
                    $v->url = "http://".$v->url;
                }
            }
            if(empty($icon_image)){
            ?>

            <a href="<?php echo $v->url; ?>" target="_blank"><i class="fa <?php echo $v->icon; ?> <?php echo $settings->social_profiles_size; ?>"></i></a>
            <?php 
            }else{
            ?>

            <a href="<?php echo $v->url; ?>" target="_blank"><img src="<?php echo $icon_image; ?>"></a>

            <?php
            }
        }
        $social_profiles = ob_get_clean();
        //var_dump($social_profiles);
        $social_profiles = trim(preg_replace( "/\r|\n/","",$social_profiles));
        }
        //var_dump($settings);
    ?>

    
        <?php
        if(!empty($settings->header_scripts)){
            echo $settings->header_scripts;
        }
        ?>
        <script>
        jQuery( document ).ready(function($) {
            <?php if(!empty($settings->logo_link)) { ?>
            jQuery("#login h1 a").prop('href','<?php echo $settings->logo_link; ?>').prop('title','<?php echo str_replace("'","\'",$settings->logo_alt); ?>');
            <?php } ?>

            <?php if(!empty($settings->description)) { ?>
            jQuery("#loginform").prepend('<div id="clpio-login-desc"><?php echo str_replace("'","\'",preg_replace( "/\r|\n/", "", nl2br(do_shortcode($settings->description)))); ?></div>');
            <?php } ?>
            

            <?php if(!empty($settings->description_below)) { 
            ?>
            jQuery("#loginform").append('<div id="clpio-login-desc-below"><?php echo str_replace("'","\'",preg_replace( "/\r|\n/", "", nl2br(do_shortcode($settings->description_below)))); ?></div>');
            <?php } ?>
            

            <?php if(!empty($settings->lost_password_msg)) { ?>
                  jQuery('.login-action-lostpassword .message').html('<?php echo str_replace("'","\'",preg_replace( "/\r|\n/", "", nl2br($settings->lost_password_msg))); ?>');      
            <?php } ?>

            <?php if(!empty($settings->registration_msg)) { ?>
                  jQuery('.login-action-register .message').html('<?php echo str_replace("'","\'",preg_replace( "/\r|\n/", "", nl2br($settings->registration_msg))); ?>');      
            <?php } ?>

            

            <?php 
            if(!empty($social_profiles)) { 
            ?>
            jQuery("#loginform").append('<div id="clpio-social-profiles"><?php echo $social_profiles; ?></div>');
            <?php } ?>
            
            

            jQuery( "#login" ).wrap( "<div id='clpio-page'></div>" );

            <?php if(!empty($settings->u_e_txt)){ ?>
            jQuery("label[for='user_login']")
              // get all child nodes including text and comment
              .contents()
              // iterate and filter out elements
              .filter(function() {
                // check node is text and non-empty
                return this.nodeType === 3 && this.textContent.trim().length;
                // replace it with new text
              }).replaceWith('<?php echo htmlentities($settings->u_e_txt,ENT_QUOTES, "UTF-8"); ?>');
            <?php } ?>

            <?php if(!empty($settings->pass_txt)){ ?>
            jQuery("label[for='user_pass']")
              // get all child nodes including text and comment
              .contents()
              // iterate and filter out elements
              .filter(function() {
                // check node is text and non-empty
                return this.nodeType === 3 && this.textContent.trim().length;
                // replace it with new text
              }).replaceWith('<?php echo htmlentities($settings->pass_txt,ENT_QUOTES, "UTF-8"); ?>');
            <?php } ?>

            <?php if(!empty($settings->remember_txt)){ ?>
            jQuery("label[for='rememberme']")
              // get all child nodes including text and comment
              .contents()
              // iterate and filter out elements
              .filter(function() {
                // check node is text and non-empty
                return this.nodeType === 3 && this.textContent.trim().length;
                // replace it with new text
              }).replaceWith('<?php echo htmlentities($settings->remember_txt,ENT_QUOTES, "UTF-8"); ?>');
            <?php } ?>

            <?php if(!empty($settings->login_txt)){ ?>
            jQuery('#wp-submit').val('<?php echo $settings->login_txt; ?>');
            <?php } ?>

            <?php if(!empty($settings->register_txt)){ ?>
            jQuery('#nav a[href*="register"]').text('<?php echo $settings->register_txt; ?>');
            <?php } ?>

            <?php if(!empty($settings->register_link)){ ?>
            jQuery('#nav a[href*="register"]').prop('href','<?php echo $settings->register_link; ?>');
            <?php } ?>

            <?php if(!empty($settings->lost_txt)){ ?>
            jQuery('#nav a[href*="lostpassword"]').text('<?php echo $settings->lost_txt; ?>');
            <?php } ?>

            <?php if(!empty($settings->back_txt)){ ?>
            jQuery('#backtoblog a').text('<?php echo $settings->back_txt; ?>');
            <?php } ?>




        });
        </script>  

        <!-- Animate -->
        <?php if(!empty($settings->container_effect_animation)): ?>
        <?php if(!empty($settings->background_image)): ?>

            <script>
            jQuery('<img/>').attr('src', '<?php echo $settings->background_image; ?>').load(function() {
               jQuery(this).remove(); // prevent memory leaks as @benweet suggested
               jQuery("#login").css('visibility', 'visible').addClass('animated <?php echo $settings->container_effect_animation; ?>');
            }).error(function() {
               jQuery(this).remove(); // prevent memory leaks as @benweet suggested
               jQuery("#login").css('visibility', 'visible').addClass('animated <?php echo $settings->container_effect_animation; ?>');   
            });
            </script>
        <?php else: ?>
        <script>
        jQuery( document ).ready(function() {
            jQuery("#login").css('visibility', 'visible').addClass('animated <?php echo $settings->container_effect_animation; ?>');
        });
        </script>
        <?php endif; ?>
        <?php endif; ?>

        <?php
        if(isset($_GET['seed_clp_preview'])){
        ?>
        <script>
        jQuery( document ).ready(function() {
        jQuery("#loginform").attr('action',jQuery("#loginform").attr('action')+'?seed_clp_preview=1');
        jQuery("#lostpasswordform").attr('action',jQuery("#lostpasswordform").attr('action')+'&seed_clp_preview=1');

        jQuery("#registerform").attr('action',jQuery("#lostpasswordform").attr('action')+'&seed_clp_preview=1');

        jQuery("#nav a[href$='wp-login.php']").attr('href',jQuery("#nav a[href$='wp-login.php']").attr('href')+'?seed_clp_preview=1');

        jQuery("#nav a[href*='register']").attr('href',jQuery("#nav a[href*='register']").attr('href')+'&seed_clp_preview=1');

        jQuery("#nav a[href*='lostpassword']").attr('href',jQuery("#nav a[href*='lostpassword']").attr('href')+'&seed_clp_preview=1');



        jQuery("#user_login").val('');
        });
        </script>
        <?php
        }
        ?>

    <?php if(!empty($settings->bg_slideshow)): ?>
        <script src="<?php echo SEED_CLP_PLUGIN_URL ?>inc/js/backstretch.js"></script>
        <!-- Slideshow -->
        <script>
        jQuery(document).ready(function($){

        $.backstretch([
<?php if(!empty($settings->bg_slideshow_images)): ?>
            <?php $i = 0; ?>
            <?php foreach($settings->bg_slideshow_images as $k=>$v) { ?>
                <?php if($i !== 0): ?>
                ,
                <?php endif; ?>
                <?php if(!empty($v)): ?>
                    '<?php echo trim($v); ?>'
                <?php endif; ?>
                <?php $i++; ?>
            <?php } ?>
        <?php endif; ?>
        ], {
            fade: 750,
        <?php if(!empty($settings->bg_slideshow_slide_speed)): ?>
            duration: <?php echo $settings->bg_slideshow_slide_speed * 1000; ?>,
        <?php else: ?>
            duration:3000,
        <?php endif; ?>
        });

        });


        </script>
    <?php endif; ?>

    <?php if(!empty($settings->bg_video)): ?>
        <?php if(!empty($settings->bg_video_url)): 
                $video_id = seed_clp_youtube_id_from_url($settings->bg_video_url);
        ?>
                

                <?php if(!empty($settings->bg_video) && !empty($video_id) ): ?>
                <!-- Tubular -->
                <script src="<?php echo SEED_CLP_PLUGIN_URL ?>inc/js/tubular.js"></script>
                <?php endif; ?>
                
                <?php if(!empty($settings->bg_video) && empty($video_id) ): ?>
                <!-- BigVideo -->
                <script src="<?php echo SEED_CLP_PLUGIN_URL ?>inc/js/video.js"></script>
                <script src="<?php echo SEED_CLP_PLUGIN_URL ?>inc/js/bigvideo.js"></script>
                <?php endif; ?>

                <?php
                //$bg_video_url_arr = '';
                //parse_str( parse_url( $settings->bg_video_url, PHP_URL_QUERY ), $bg_video_url_arr );
                
                
                $audio = 'false';
                if(empty($settings->bg_video_audio)){
                    $audio = 'true';
                }

                 $loop = 'true';
                if(empty($settings->bg_video_loop)){
                    $loop = 'false';
                }
                ?>

    
                <script>
                <?php if(!empty($video_id)){ ?>
                jQuery(document).ready(function($){
                    if (Modernizr.touchevents == false) {
                        $('#clpio-page').tubular({
                        videoId: '<?php echo $video_id; ?>',
                        mute: <?php echo $audio; ?>,
                        repeat: <?php echo $loop; ?>,
                        });
                    }
                });
                <?php }else{ ?>
                jQuery(document).ready(function($){
                    if (Modernizr.touchevents == false) {
                        var BV = new $.BigVideo();
                        BV.init();
                        BV.show('<?php echo $settings->bg_video_url ?>',{ambient:<?php echo $audio; ?>,doLoop:<?php echo $loop; ?>});
                        $('#big-video-wrap').show()
                    }
                });
                <?php } ?>
                </script>


        <?php endif; ?>
    <?php endif; ?>



    <?php
    }

}

// YouTube video ID
function seed_clp_youtube_id_from_url($url) {
    $pattern =
        '%^# Match any youtube URL
        (?:https?://)?  # Optional scheme. Either http or https
        (?:www\.)?      # Optional www subdomain
        (?:             # Group host alternatives
          youtu\.be/    # Either youtu.be,
        | youtube\.com  # or youtube.com
          (?:           # Group path alternatives
            /embed/     # Either /embed/
          | /v/         # or /v/
          | /watch\?v=  # or /watch\?v=
          )             # End path alternatives.
        )               # End host alternatives.
        ([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
        $%x'
        ;
    $result = preg_match($pattern, $url, $matches);
    if (false !== $result) {
        if(isset($matches[1]))
            return $matches[1];
    }
    return false;
}

