<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 *
 */

if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>

	<h3 class="comments-title"><?php esc_html_e('Comments', 'cryption'); ?> <span class="light">(<?php echo get_comments_number(); ?>)</span></h3>

	<div class="large-title-sep"></div>

	<div class="comment-list">
		<?php
			wp_list_comments( array(
				'style'      => 'div',
				'short_ping' => true,
				'avatar_size'=> 70,
				'callback' => 'cryption_comment'
			) );
		?>
	</div><!-- .comment-list -->

	<?php if ( ! comments_open() ) : ?>
	<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'cryption' ); ?></p>
	<?php endif; ?>

	<?php endif; // have_comments() ?>

<?php
	$comments_form_args = array(
		'fields' => array(
			'author' => '<div class="col-md-4 col-xs-12 comment-author-input"><input type="text" name="author" id="comment-author" value="'.esc_attr($comment_author).'" size="22" tabindex="1"'.($req ? ' aria-required="true"' : '').' placeholder="'.esc_attr__('Name', 'cryption').($req ? ' *' : '').'" /></div>',
			'email' => '<div class="col-md-4 col-xs-12 comment-email-input"><input type="text" name="email" id="comment-email" value="'.esc_attr($comment_author_email).'" size="22" tabindex="2"'.($req ? ' aria-required="true"' : '').' placeholder="'.esc_attr__('Mail', 'cryption').($req ? ' *' : '').'" /></div>',
			'url' => '<div class="col-md-4 col-xs-12 comment-url-input"><input type="text" name="url" id="comment-url" value="'.esc_attr($comment_author_url).'" size="22" tabindex="3" placeholder="'.esc_attr__('Website', 'cryption').'" /></div>'
		),
		'comment_notes_after' => '',
		'comment_notes_before' => '',
		'comment_field' => '<div class="row"><div class="col-xs-12"><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4" placeholder="'.esc_attr_x('Comment *', 'noun', 'cryption').'"></textarea></div></div>',
		'must_log_in' => '<div class="comment-form-message">'.sprintf(wp_kses(__('You must be <a href="%s">logged in</a> to post a comment.', 'cryption'), array('a' => array('href' => array()))), esc_url(wp_login_url( get_permalink() ))).'</div>',
		'logged_in_as' => '<div class="comment-form-message">'.sprintf(wp_kses(__('Logged in as <a href="%1$s">%2$s</a>.', 'cryption'), array('a' => array('href' => array()))), esc_url(get_edit_user_link()), $user_identity).' <a href="'.esc_url(wp_logout_url(get_permalink())).'" title="'.esc_attr__('Log out of this account', 'cryption').'">'.esc_html__('Log out &raquo;', 'cryption').'</a></div>',
		'submit_field' => '<div class="form-submit ct-button-position-inline">%1$s</div><p>%2$s</p>',
		'label_submit' => esc_html__('Send Comment', 'cryption'),
		'class_submit' => 'ct-button ct-button-size-small submit ct-button-icon-position-right',
        'title_reply_before' => '<h3 id="reply-title" class="comment-reply-title">',
        'title_reply_after' => '</h3>',
		'submit_button' => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">%4$s<i class="ct-print-icon ct-icon-pack-ct-icons ct-icon-more"></i></button>',
		'title_reply' => '<div class="leave-a-comment-title">' . wp_kses(__('Leave a ', 'cryption'), array('span' => array('class' => array()))) . '<span>' . wp_kses(__('comment', 'cryption'), array('span' => array('class' => array())))  . ' </span></div>' ,
		'title_reply_to' => esc_html__('Comment to %s', 'cryption'),
		'must_log_in' => sprintf(wp_kses(__('You must be <a href="%s">logged in</a> to post a comment.', 'cryption'), array('a' => array('href' => array()))), esc_url(wp_login_url( get_permalink() ))),
	);
	comment_form($comments_form_args);
?>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
	<nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
		<div class="nav-previous"><?php previous_comments_link( esc_html__( 'Prev', 'cryption' ) ); ?></div>
		<div class="nav-next"><?php next_comments_link( esc_html__( 'Next', 'cryption' ) ); ?></div>
	</nav><!-- #comment-nav-below -->
	<?php endif; // Check for comment navigation. ?>

</div><!-- #comments -->
